<?php
/* --------------------------------------------------------------
 EmailTransportMethod.php 2019-12-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Types;

use Gambio\Core\Configuration\Models\Read\Collections\Options;
use Gambio\Core\Configuration\Models\Read\Option;
use Gambio\Core\Configuration\Repositories\Components\OptionsResolver;

/**
 * Class EmailTransportMethod
 * @package Gambio\Core\Configuration\Types
 */
class EmailTransportMethod implements ConfigurationType
{
    /**
     * @inheritDoc
     */
    public function toOptions(OptionsResolver $resolver, string $value = null): ?Options
    {
        $options = [
            Option::create('sendmail', 'sendmail'),
            Option::create('smtp', 'smtp'),
            Option::create('mail', 'mail'),
        ];
        
        return Options::create(...$options);
    }
    
    
    /**
     * @inheritDoc
     */
    public function inputType(): string
    {
        return 'dropdown';
    }
}